/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;

public final class Strings {
    private static final String _TT = "carrots.tooltip.";
    public static final String __DEFAULT_VAL = "*DEFAULT*";
    public static final String __NONE_VAL = "*NONE*";
    public static final int MAX_MENU_WIDTH = 33;
    public static final int MAX_DISPLAY_ITEM_COUNT = 10;

    public static final String translate(String key) {
        return I18n.func_74838_a((String)key);
    }

    public static final String translateDefault(String key, String defaultValue) {
        String out = Strings.translate(key);
        return !key.equals(out) && !StringUtils.isBlank((CharSequence)out) ? out : defaultValue;
    }

    public static final String translateFormatted(String key, Object ... format) {
        return I18n.func_74837_a((String)key, (Object[])format);
    }

    public static final String translateFormattedDefault(String key, String defaultValue, Object ... format) {
        String out = I18n.func_74837_a((String)key, (Object[])format);
        return !key.equals(out) && !StringUtils.isBlank((CharSequence)out) ? out : defaultValue;
    }

    public static final boolean hasTranslation(String key) {
        return I18n.func_94522_b((String)key);
    }

    public static final String tooltipKey(String key) {
        return _TT + String.valueOf(key);
    }

    public static final String translateTooltip(String key) {
        return Strings.translate(_TT + key);
    }

    public static final String translateTooltip(String key, String defaultValue) {
        return Strings.translateDefault(_TT + key, defaultValue);
    }

    public static final boolean isDefaultValue(@Nullable String s, boolean emptyIsTrue) {
        return (s = StringUtils.trimToNull((String)s)) == null ? emptyIsTrue : "DEFAULT".equals(StringUtils.strip((String)s.toUpperCase(Locale.US), (String)"*_"));
    }

    public static final boolean isDefaultValue(@Nullable String s) {
        return Strings.isDefaultValue(s, true);
    }

    public static final String[] __DEFAULT_VAL_SETTINGS() {
        return new String[]{__DEFAULT_VAL, Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    }

    public static final boolean isNoneValue(@Nullable String s, boolean emptyIsTrue) {
        return (s = StringUtils.trimToNull((String)s)) == null ? emptyIsTrue : "NONE".equals(StringUtils.strip((String)s.toUpperCase(Locale.US), (String)"*_"));
    }

    public static final boolean isNoneValue(@Nullable String s) {
        return Strings.isNoneValue(s, false);
    }

    public static final String boundedDisplayString(@Nonnull ItemStack item, int reserved_width) {
        return StringUtils.abbreviate((String)item.func_82833_r(), (int)(33 - reserved_width));
    }

    public static final String boundedUiTipString(@Nonnull ItemStack item, int reserved_width) {
        String s = item.func_82833_r() + (ItemStacks.isSingle(item) ? "" : " (" + ItemStacks.getSize(item) + ")");
        return StringUtils.abbreviate((String)s, (int)(33 - reserved_width));
    }

    private Strings() {
    }

    public static final void init() {
    }
}

